import { cn } from "@/lib/utils";
import { ComponentWithClassNameAndChildren } from "@/types/utils";

export function StatusBannerIconWrapper({ className, children }: ComponentWithClassNameAndChildren) {
  return (
    <div className={cn("pl-4 grid place-items-center", className)}>
      <div
        className="flex size-9 shrink-0 items-center justify-center rounded-full border border-border"
        aria-hidden="true"
      >
        {children}
      </div>
    </div>
  )
}

export function StatusBannerContentWrapper({ className, children }: ComponentWithClassNameAndChildren) {
  return (
    <div className={cn("p-4 flex-1 grid grow gap-12 text-pretty", className)}>
      <div className="space-y-1">
        {children}
      </div>
    </div>
  )
}

export function StatusBannerWrapper({ className, children }: ComponentWithClassNameAndChildren) {
  return (
    <div className={cn("rounded-xl border border-border bg-background shadow-sm relative", className)}>
      <div className="grid grid-cols-[auto,_1fr,_auto]">
        {children}
      </div>
    </div>
  )
}
